<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('leagues', function (Blueprint $table) {
      $table->id();
      $table->string("title")->unique()->require();
      $table->integer("trip")->unique()->require();
      $table->integer("star")->unique()->require();
      $table->boolean("disabled")->default(false);
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('leagues');
  }
};
